/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import java.util.List;

public class AssignmentCommand
extends AbstractCommand {
    public AssignmentCommand() {
        this.setName("assignment");
        this.setSyntax("assignment [set/add/remove/clear] (script:<name>) (to:<npc>|...)");
        this.setRequiredArguments(1, 3);
        this.autoCompile();
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.add(Action.values());
        tab.addScriptsOfType(AssignmentScriptContainer.class);
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="action") Action action, @ArgName(value="linearScript") @ArgLinear @ArgDefaultNull ScriptTag linearScript, @ArgName(value="linearTo") @ArgLinear @ArgDefaultNull @ArgSubType(value=NPCTag.class) List<NPCTag> linearTo, @ArgName(value="script") @ArgPrefixed @ArgDefaultNull ScriptTag script, @ArgName(value="to") @ArgPrefixed @ArgDefaultNull @ArgSubType(value=NPCTag.class) List<NPCTag> to) {
        PlayerTag player = Utilities.getEntryPlayer(scriptEntry);
        if (linearScript != null) {
            BukkitImplDeprecations.assignmentOptionalPrefixArgs.warn(scriptEntry);
            script = linearScript;
        }
        if (linearTo != null) {
            BukkitImplDeprecations.assignmentOptionalPrefixArgs.warn(scriptEntry);
            to = linearTo;
        }
        if (to == null) {
            if (!Utilities.entryHasNPC(scriptEntry)) {
                throw new InvalidArgumentsRuntimeException("This command requires a linked NPC!");
            }
            to = List.of(Utilities.getEntryNPC(scriptEntry));
        }
        switch (action.ordinal()) {
            case 0: {
                if (script == null) {
                    throw new InvalidArgumentsRuntimeException("Missing script!");
                }
                ScriptContainer scriptContainer = script.getContainer();
                if (!(scriptContainer instanceof AssignmentScriptContainer)) {
                    throw new InvalidArgumentsRuntimeException("Script specified is not an 'assignment-type' container.");
                }
                AssignmentScriptContainer assignmentScriptContainer = (AssignmentScriptContainer)scriptContainer;
                for (NPCTag npc : to) {
                    AssignmentTrait assignment = (AssignmentTrait)npc.getCitizen().getOrAddTrait(AssignmentTrait.class);
                    assignment.clearAssignments(player);
                    assignment.addAssignmentScript(assignmentScriptContainer, player);
                }
                break;
            }
            case 1: {
                if (script == null) {
                    throw new InvalidArgumentsRuntimeException("Missing script!");
                }
                ScriptContainer scriptContainer = script.getContainer();
                if (!(scriptContainer instanceof AssignmentScriptContainer)) {
                    throw new InvalidArgumentsRuntimeException("Script specified is not an 'assignment-type' container.");
                }
                AssignmentScriptContainer assignmentScriptContainer = (AssignmentScriptContainer)scriptContainer;
                for (NPCTag npc : to) {
                    ((AssignmentTrait)npc.getCitizen().getOrAddTrait(AssignmentTrait.class)).addAssignmentScript(assignmentScriptContainer, player);
                }
                break;
            }
            case 2: {
                for (NPCTag npc : to) {
                    if (script == null) {
                        BukkitImplDeprecations.assignmentRemove.warn(scriptEntry);
                        if (!npc.getCitizen().hasTrait(AssignmentTrait.class)) continue;
                        ((AssignmentTrait)npc.getCitizen().getOrAddTrait(AssignmentTrait.class)).clearAssignments(player);
                        npc.getCitizen().removeTrait(AssignmentTrait.class);
                        continue;
                    }
                    if (!npc.getCitizen().hasTrait(AssignmentTrait.class)) continue;
                    AssignmentTrait trait = (AssignmentTrait)npc.getCitizen().getOrAddTrait(AssignmentTrait.class);
                    trait.removeAssignmentScript(script.getName(), player);
                    trait.checkAutoRemove();
                }
                break;
            }
            case 3: {
                for (NPCTag npc : to) {
                    if (!npc.getCitizen().hasTrait(AssignmentTrait.class)) continue;
                    ((AssignmentTrait)npc.getCitizen().getOrAddTrait(AssignmentTrait.class)).clearAssignments(player);
                    npc.getCitizen().removeTrait(AssignmentTrait.class);
                }
                break;
            }
        }
    }

    public static enum Action {
        SET,
        ADD,
        REMOVE,
        CLEAR;

    }
}

