/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizen.utilities.inventory.InventoryViewUtil;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.destroystokyo.paper.event.block.AnvilDamagedEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;

public class AnvilBlockDamagedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public AnvilDamagedEvent event;

    public AnvilBlockDamagedScriptEvent() {
        this.registerCouldMatcher("anvil block damaged|breaks");
        this.registerSwitches("state");
        this.registerOptionalDetermination("state", ElementTag.class, (evt, context, state) -> {
            if (state.matchesEnum(AnvilDamagedEvent.DamageState.class)) {
                evt.event.setDamageState(state.asEnum(AnvilDamagedEvent.DamageState.class));
                return true;
            }
            return false;
        });
        this.registerOptionalDetermination("break", ElementTag.class, (evt, context, value) -> {
            if (value.isBoolean()) {
                evt.event.setBreaking(value.asBoolean());
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.eventArgLowerAt(2).equals("breaks") && !this.event.isBreaking()) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getInventory().getLocation())) {
            return false;
        }
        if (!AnvilBlockDamagedScriptEvent.runGenericSwitchCheck(path, "state", this.event.getDamageState().name())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "state" -> new ElementTag((Enum<?>)this.event.getDamageState());
            case "inventory" -> InventoryTag.mirrorBukkitInventory((Inventory)this.event.getInventory());
            case "break" -> new ElementTag(this.event.isBreaking());
            default -> super.getContext(name);
        };
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)InventoryViewUtil.getPlayer(this.event.getView()));
    }

    @EventHandler
    public void onAnvilDamaged(AnvilDamagedEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

