/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import io.papermc.paper.event.player.PlayerLoomPatternSelectEvent;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;

public class PlayerLoomPatternSelectScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerLoomPatternSelectEvent event;

    public PlayerLoomPatternSelectScriptEvent() {
        this.registerCouldMatcher("player selects loom pattern");
        this.registerSwitches("type");
        this.registerOptionalDetermination("pattern", ElementTag.class, (evt, context, pattern) -> {
            if (Utilities.matchesEnumlike(pattern, PatternType.class)) {
                evt.event.setPatternType(Utilities.elementToEnumlike(pattern, PatternType.class));
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getLoomInventory().getLocation())) {
            return false;
        }
        if (!path.tryObjectSwitch("type", Utilities.enumlikeToElement(this.event.getPatternType()))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "loom" -> InventoryTag.mirrorBukkitInventory((Inventory)this.event.getLoomInventory());
            case "pattern" -> Utilities.enumlikeToElement(this.event.getPatternType());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onPlayerSelectsLoomPattern(PlayerLoomPatternSelectEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

