/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.FormatScriptContainer;
import com.denizenscript.denizencore.tags.ParseableTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public record ScriptFormattingContext(Map<String, ParseableTag> formats, ParseableTag singleFormat) {
    public static final Set<String> FORMAT_TYPES = new HashSet<String>();

    public static String registerFormatType(String name) {
        String nameLower = CoreUtilities.toLowerCase(name);
        if (!FORMAT_TYPES.add(nameLower)) {
            throw new IllegalArgumentException("Tried registering duplicate format type! format '" + name + "' already exists.");
        }
        return nameLower;
    }

    public static ScriptFormattingContext parseFromConfiguration(ScriptContainer script) {
        YamlConfiguration formatsConfig = script.getConfigurationSection("formats");
        if (formatsConfig == null) {
            return null;
        }
        HashMap<String, ParseableTag> formats = new HashMap<String, ParseableTag>();
        TagContext context = null;
        for (String formatType : FORMAT_TYPES) {
            String rawFormat = formatsConfig.getString(formatType);
            if (rawFormat != null) {
                if (context == null) {
                    context = DenizenCore.implementation.getTagContext(script);
                }
                formats.put(formatType, TagManager.parseTextToTag(rawFormat, context));
                continue;
            }
            String formatScriptInput = formatsConfig.getString(formatType + "_script");
            if (formatScriptInput == null) continue;
            FormatScriptContainer formatScript = ScriptRegistry.getScriptContainerAs(formatScriptInput, FormatScriptContainer.class);
            if (formatScript == null || formatScript.getFormatTag() == null) {
                Debug.echoError(script, "Invalid format script '" + formatScriptInput + "' specified for format '" + formatType + "'.");
                continue;
            }
            formats.put(formatType, formatScript.getFormatTag());
        }
        if (formats.isEmpty()) {
            Debug.echoError(script, "Invalid formats config, must specify at least one valid format.");
            return null;
        }
        return new ScriptFormattingContext(formats, null);
    }

    public boolean hasFormat(String formatType) {
        return this.singleFormat != null || this.formats.containsKey(formatType);
    }

    public String formatOrNull(String formatType, String rawText, ScriptEntry entry) {
        ParseableTag formatTag = this.singleFormat == null ? this.formats.get(formatType) : this.singleFormat;
        return formatTag != null ? FormatScriptContainer.formatText(formatTag, rawText, entry.getContext(), entry.getScript()) : null;
    }

    public String format(String formatType, String rawText, ScriptEntry entry) {
        String formatted = this.formatOrNull(formatType, rawText, entry);
        return formatted != null ? formatted : rawText;
    }
}

