/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.entity.Bogged;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Snowman;

public class EntitySheared
extends EntityProperty<ElementTag> {
    public static boolean describes(EntityTag entity) {
        return entity.getBukkitEntity() instanceof Sheep || entity.getBukkitEntity() instanceof Snowman || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && entity.getBukkitEntity() instanceof Bogged;
    }

    @Override
    public ElementTag getPropertyValue() {
        Entity entity = this.getEntity();
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            return new ElementTag(sheep.isSheared());
        }
        entity = this.getEntity();
        if (entity instanceof Snowman) {
            Snowman snowman = (Snowman)entity;
            return new ElementTag(snowman.isDerp());
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (entity = this.getEntity()) instanceof Bogged) {
            Bogged bogged = (Bogged)entity;
            return new ElementTag(bogged.isSheared());
        }
        return null;
    }

    @Override
    public void setPropertyValue(ElementTag param, Mechanism mechanism) {
        if (!mechanism.requireBoolean()) {
            return;
        }
        Entity entity = this.getEntity();
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            sheep.setSheared(param.asBoolean());
        } else {
            entity = this.getEntity();
            if (entity instanceof Snowman) {
                Snowman snowman = (Snowman)entity;
                snowman.setDerp(param.asBoolean());
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (entity = this.getEntity()) instanceof Bogged) {
                Bogged bogged = (Bogged)entity;
                bogged.setSheared(param.asBoolean());
            }
        }
    }

    @Override
    public String getPropertyId() {
        return "sheared";
    }

    public static void register() {
        EntitySheared.autoRegister("sheared", EntitySheared.class, ElementTag.class, false, new String[0]);
        PropertyParser.registerTag(EntitySheared.class, ElementTag.class, "is_sheared", (attribute, prop) -> {
            BukkitImplDeprecations.entityIsSheared.warn(attribute.context);
            return prop.getPropertyValue();
        }, new String[0]);
        PropertyParser.registerTag(EntitySheared.class, ElementTag.class, "has_pumpkin_head", (attribute, prop) -> {
            BukkitImplDeprecations.entityIsSheared.warn(attribute.context);
            if (!(prop.getEntity() instanceof Snowman)) {
                return null;
            }
            return new ElementTag(!prop.getPropertyValue().asBoolean());
        }, new String[0]);
        PropertyParser.registerMechanism(EntitySheared.class, ElementTag.class, "has_pumpkin_head", (prop, mechanism, input) -> {
            BukkitImplDeprecations.entityIsSheared.warn(mechanism.context);
            if (!(prop.getEntity() instanceof Snowman)) {
                return;
            }
            prop.setPropertyValue(new ElementTag(!input.asBoolean()), mechanism);
        }, new String[0]);
    }
}

