/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_18.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_18.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.chunk.Chunk;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public Holder<BiomeBase> biomeBase;
    public WorldServer world;

    public BiomeNMSImpl(WorldServer world, NamespacedKey key) {
        super((World)world.getWorld(), key);
        this.world = world;
        this.biomeBase = world.s().d(IRegistry.aP).b(ResourceKey.a((ResourceKey)IRegistry.aP, (MinecraftKey)CraftNamespacedKey.toMinecraft((NamespacedKey)key))).orElse(null);
    }

    @Override
    public BiomeNMS.DownfallType getDownfallType() {
        BiomeBase.Precipitation nmsType = ((BiomeBase)this.biomeBase.a()).c();
        return switch (nmsType) {
            case BiomeBase.Precipitation.b -> BiomeNMS.DownfallType.RAIN;
            case BiomeBase.Precipitation.c -> BiomeNMS.DownfallType.SNOW;
            case BiomeBase.Precipitation.a -> BiomeNMS.DownfallType.NONE;
            default -> throw new UnsupportedOperationException();
        };
    }

    @Override
    public float getHumidity() {
        return ((BiomeBase)this.biomeBase.a()).h();
    }

    @Override
    public float getBaseTemperature() {
        return ((BiomeBase)this.biomeBase.a()).i();
    }

    @Override
    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(EnumCreatureType.c);
    }

    @Override
    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(EnumCreatureType.b);
    }

    @Override
    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.a);
    }

    @Override
    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.f);
    }

    @Override
    public int getFoliageColor() {
        if (((BiomeBase)this.biomeBase.a()).g() != 0) {
            return ((BiomeBase)this.biomeBase.a()).g();
        }
        float temperature = this.clampColor(this.getBaseTemperature());
        float humidity = this.clampColor(this.getHumidity());
        int temperatureValue = (int)((1.0f - temperature) * 255.0f);
        int humidityValue = (int)((1.0f - (humidity *= temperature)) * 255.0f);
        int index = temperatureValue << 8 | humidityValue;
        return index >= 65536 ? 4764952 : this.getColor(index / 256, index % 256).asRGB();
    }

    public Object getClimate() {
        return ReflectionHelper.getFieldValue(BiomeBase.class, ReflectionMappingsInfo.Biome_climateSettings, this.biomeBase.a());
    }

    @Override
    public void setHumidity(float humidity) {
        Object climate = this.getClimate();
        ReflectionHelper.setFieldValue(climate.getClass(), ReflectionMappingsInfo.Biome_ClimateSettings_downfall, climate, Float.valueOf(humidity));
    }

    @Override
    public void setBaseTemperature(float temperature) {
        Object climate = this.getClimate();
        ReflectionHelper.setFieldValue(climate.getClass(), ReflectionMappingsInfo.Biome_ClimateSettings_temperature, climate, Float.valueOf(temperature));
    }

    @Override
    public void setPrecipitation(BiomeNMS.DownfallType type) {
        BiomeBase.Precipitation nmsType = switch (type) {
            case BiomeNMS.DownfallType.RAIN -> BiomeBase.Precipitation.b;
            case BiomeNMS.DownfallType.SNOW -> BiomeBase.Precipitation.c;
            case BiomeNMS.DownfallType.NONE -> BiomeBase.Precipitation.a;
            default -> throw new UnsupportedOperationException();
        };
        Object climate = this.getClimate();
        ReflectionHelper.setFieldValue(climate.getClass(), ReflectionMappingsInfo.Biome_ClimateSettings_precipitation, climate, nmsType);
    }

    @Override
    public void setFoliageColor(int color) {
        try {
            ReflectionHelper.setFieldValue(BiomeFog.class, ReflectionMappingsInfo.BiomeSpecialEffects_foliageColorOverride, ((BiomeBase)this.biomeBase.a()).j(), Optional.of(color));
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    private List<EntityType> getSpawnableEntities(EnumCreatureType creatureType) {
        BiomeSettingsMobs mobs = ((BiomeBase)this.biomeBase.a()).b();
        WeightedRandomList typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (BiomeSettingsMobs.c meta : typeSettingList.e()) {
            try {
                String n = EntityTypes.a((EntityTypes)meta.b).a();
                EntityType et = EntityType.fromName((String)n);
                if (et == null) {
                    et = EntityType.valueOf((String)n.toUpperCase(Locale.ENGLISH));
                }
                entityTypes.add(et);
            }
            catch (Throwable throwable) {}
        }
        return entityTypes;
    }

    @Override
    public void setTo(Block block) {
        Chunk chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getKey()).setTo(block);
            return;
        }
        BlockPosition pos = new BlockPosition(block.getX(), 0, block.getZ());
        if (this.world.C(pos) && (chunk = this.world.l(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeBase);
            chunk.a(true);
        }
    }
}

