/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizen.paper.datacomponents.DataComponentAdapter;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import io.papermc.paper.datacomponent.DataComponentType;

public class ItemRemovedComponents
extends ItemProperty<ListTag> {
    public static boolean describes(ItemTag item) {
        return !item.getItemStack().isEmpty();
    }

    public boolean isRemoved(DataComponentType componentType) {
        return this.getItemStack().isDataOverridden(componentType) && !this.getItemStack().hasData(componentType);
    }

    @Override
    public ListTag getPropertyValue() {
        return new ListTag(this.getMaterial().getDefaultDataTypes(), this::isRemoved, componentType -> new ElementTag(componentType.key().asMinimalString(), true));
    }

    @Override
    public boolean isDefaultValue(ListTag value) {
        return value.isEmpty();
    }

    @Override
    public void setPropertyValue(ListTag value, Mechanism mechanism) {
        for (DataComponentType componentType : this.getMaterial().getDefaultDataTypes()) {
            if (!this.isRemoved(componentType)) continue;
            this.getItemStack().resetData(componentType);
        }
        for (String input : value) {
            DataComponentType componentType = DataComponentAdapter.getComponentType(input);
            if (componentType == null) {
                mechanism.echoError("Invalid type to remove '" + input + "' specified: must be a valid property or item component name.");
                continue;
            }
            this.getItemStack().unsetData(componentType);
        }
    }

    @Override
    public String getPropertyId() {
        return "removed_components";
    }

    public static void register() {
        ItemRemovedComponents.autoRegister("removed_components", ItemRemovedComponents.class, ListTag.class, false, new String[0]);
        PropertyParser.registerMechanism(ItemRemovedComponents.class, ElementTag.class, "remove_component", (prop, mechanism, input) -> {
            DataComponentType componentType = DataComponentAdapter.getComponentType(input.asString());
            if (componentType == null) {
                mechanism.echoError("Invalid type to remove specified: must be a valid property or item component name.");
                return;
            }
            prop.getItemStack().unsetData(componentType);
        }, new String[0]);
    }
}

