/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bridges;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.depenizen.bukkit.Bridge;
import com.denizenscript.depenizen.bukkit.events.askyblock.PlayerCompletesSkyBlockChallengeScriptEvent;
import com.denizenscript.depenizen.bukkit.events.askyblock.PlayerEntersSkyBlockScriptEvent;
import com.denizenscript.depenizen.bukkit.events.askyblock.PlayerExitsSkyBlockScriptEvent;
import com.denizenscript.depenizen.bukkit.events.askyblock.SkyBlockCreatedScriptEvent;
import com.denizenscript.depenizen.bukkit.events.askyblock.SkyBlockResetScriptEvent;
import com.denizenscript.depenizen.bukkit.properties.askyblock.ASkyBlockLocationProperties;
import com.denizenscript.depenizen.bukkit.properties.askyblock.ASkyBlockPlayerProperties;
import com.denizenscript.depenizen.bukkit.properties.askyblock.ASkyBlockWorldProperties;
import com.wasteofplastic.askyblock.ASkyBlockAPI;

public class ASkyBlockBridge
extends Bridge {
    public ASkyBlockAPI api;

    @Override
    public void init() {
        this.api = ASkyBlockAPI.getInstance();
        PropertyParser.registerProperty(ASkyBlockPlayerProperties.class, PlayerTag.class);
        PropertyParser.registerProperty(ASkyBlockLocationProperties.class, LocationTag.class);
        PropertyParser.registerProperty(ASkyBlockWorldProperties.class, WorldTag.class);
        ScriptEvent.registerScriptEvent(SkyBlockCreatedScriptEvent.class);
        ScriptEvent.registerScriptEvent(SkyBlockResetScriptEvent.class);
        ScriptEvent.registerScriptEvent(PlayerEntersSkyBlockScriptEvent.class);
        ScriptEvent.registerScriptEvent(PlayerExitsSkyBlockScriptEvent.class);
        ScriptEvent.registerScriptEvent(PlayerCompletesSkyBlockChallengeScriptEvent.class);
        TagManager.registerTagHandler((TagRunnable.RootForm)new TagRunnable.RootForm(){

            public void run(ReplaceableTagEvent event) {
                ASkyBlockBridge.this.tagEvent(event);
            }
        }, (String[])new String[]{"skyblock"});
    }

    public void tagEvent(ReplaceableTagEvent event) {
        Attribute attribute = event.getAttributes().fulfill(1);
        if (attribute.startsWith("island_world")) {
            event.setReplacedObject(new WorldTag(this.api.getIslandWorld()).getObjectAttribute(attribute.fulfill(1)));
        } else if (attribute.startsWith("nether_world")) {
            event.setReplacedObject(new WorldTag(this.api.getNetherWorld()).getObjectAttribute(attribute.fulfill(1)));
        } else if (attribute.startsWith("island_count")) {
            event.setReplacedObject(new ElementTag(this.api.getIslandCount()).getObjectAttribute(attribute.fulfill(1)));
        }
    }
}

