/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.bungee;

import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.BracedCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.KeepAlivePacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.RedirectPacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.redirectable.RunCommandsPacketOut;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BungeeCommand
extends BracedCommand {
    public BungeeCommand() {
        this.setName("bungee");
        this.setSyntax("bungee [<server>|...] [<commands>]");
        this.setRequiredArguments(1, 1);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("servers")) {
                scriptEntry.addObject("servers", (Object)arg.asType(ListTag.class));
                continue;
            }
            if (arg.matches("{")) break;
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("servers")) {
            throw new InvalidArgumentsException("Must define servers to run the script on.");
        }
    }

    public void execute(ScriptEntry scriptEntry) {
        ListTag servers = (ListTag)scriptEntry.getObjectTag("servers");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, (String)this.getName(), (Object[])new Object[]{servers});
        }
        if (!BungeeBridge.instance.connected) {
            Debug.echoError((String)"Cannot Bungee command: bungee is not connected!");
            return;
        }
        List bracedCommandsList = BracedCommand.getBracedCommandsDirect((ScriptEntry)scriptEntry, (ScriptEntry)scriptEntry);
        if (bracedCommandsList == null || bracedCommandsList.isEmpty()) {
            Debug.echoError((String)"Empty subsection - did you forget a ':'?");
            return;
        }
        StringBuilder toSend = new StringBuilder();
        for (ScriptEntry entry : bracedCommandsList) {
            toSend.append(BungeeCommand.stringify(entry)).append("\n");
        }
        StringBuilder defNames = new StringBuilder();
        StringBuilder defValues = new StringBuilder();
        for (Map.Entry def : scriptEntry.getResidingQueue().getAllDefinitions().entrySet()) {
            defNames.append(BungeeCommand.escape(((StringHolder)def.getKey()).low)).append("\n");
            defValues.append(BungeeCommand.escape(((ObjectTag)def.getValue()).toString())).append("\n");
        }
        RunCommandsPacketOut packetScript = new RunCommandsPacketOut(toSend.toString(), String.valueOf(defNames) + "\r" + String.valueOf(defValues), scriptEntry.shouldDebug(), Utilities.entryHasPlayer((ScriptEntry)scriptEntry) ? Utilities.getEntryPlayer((ScriptEntry)scriptEntry).getUUID() : new UUID(0L, 0L));
        for (String server : servers) {
            RedirectPacketOut packet = new RedirectPacketOut(server, packetScript);
            BungeeBridge.instance.sendPacket(packet);
            BungeeBridge.instance.sendPacket(new KeepAlivePacketOut());
        }
    }

    public static String escape(String text) {
        return text.replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r");
    }

    public static String stringify(Object obj) {
        if (obj instanceof ScriptEntry) {
            ScriptEntry entry = (ScriptEntry)obj;
            if (!(entry.internal.yamlSubcontent instanceof List)) {
                return BungeeCommand.escape(entry.internal.originalLine);
            }
            StringBuilder result = new StringBuilder();
            result.append(BungeeCommand.escape(entry.internal.originalLine)).append("\r");
            for (Object subCommand : (List)entry.internal.yamlSubcontent) {
                result.append(BungeeCommand.stringify(subCommand)).append("\r");
            }
            return result.toString();
        }
        if (obj instanceof Map) {
            Map valueMap = (Map)obj;
            StringBuilder result = new StringBuilder();
            Object cmdLine = valueMap.keySet().toArray()[0];
            result.append(BungeeCommand.escape(cmdLine.toString())).append("\r");
            List inside = (List)valueMap.get(cmdLine);
            for (Object subCommand : inside) {
                result.append(BungeeCommand.stringify(subCommand)).append("\r");
            }
            return result.toString();
        }
        return BungeeCommand.escape(obj.toString());
    }
}

