/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.playerpoints;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.depenizen.bukkit.bridges.PlayerPointsBridge;
import org.black_ixx.playerpoints.PlayerPoints;

public class PlayerPointsCommand
extends AbstractCommand {
    public PlayerPointsCommand() {
        this.setName("playerpoints");
        this.setSyntax("playerpoints [set/give/take] [<#>]");
        this.setRequiredArguments(2, 2);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("target") && arg.matchesPrefix("target")) {
                scriptEntry.addObject("target", (Object)arg.asType(PlayerTag.class));
                Debug.echoError((String)"Don't use 'target:' for 'playerpoints' command. Just use 'player:'.");
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.class)) {
                scriptEntry.addObject("action", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("amount")) {
                scriptEntry.addObject("amount", (Object)arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Action not specified! (remove/mob/player/misc)");
        }
        if (!scriptEntry.hasObject("amount")) {
            throw new InvalidArgumentsException("Amount not specified!");
        }
        if (!scriptEntry.hasObject("target")) {
            if (Utilities.entryHasPlayer((ScriptEntry)scriptEntry)) {
                scriptEntry.addObject("target", (Object)Utilities.getEntryPlayer((ScriptEntry)scriptEntry));
            } else {
                throw new InvalidArgumentsException("This command does not have a player attached!");
            }
        }
    }

    public void execute(ScriptEntry scriptEntry) {
        PlayerTag target = (PlayerTag)scriptEntry.getObjectTag("target");
        ElementTag action = (ElementTag)scriptEntry.getObjectTag("action");
        ElementTag amount = (ElementTag)scriptEntry.getObjectTag("amount");
        Debug.report((Debuggable)scriptEntry, (String)this.getName(), (Object[])new Object[]{action, target, amount});
        if (target == null) {
            Debug.echoError((ScriptEntry)scriptEntry, (String)"Target not found!");
            return;
        }
        if (amount == null) {
            Debug.echoError((ScriptEntry)scriptEntry, (String)"Entity not specified!");
            return;
        }
        PlayerPoints plugin = (PlayerPoints)PlayerPointsBridge.instance.plugin;
        if (action.asString().equalsIgnoreCase("give")) {
            plugin.getAPI().give(target.getUUID(), amount.asInt());
        } else if (action.asString().equalsIgnoreCase("take")) {
            plugin.getAPI().take(target.getUUID(), amount.asInt());
        } else if (action.asString().equalsIgnoreCase("set")) {
            plugin.getAPI().set(target.getUUID(), amount.asInt());
        }
    }

    private static enum Action {
        SET,
        GIVE,
        TAKE;

    }
}

