/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.griefprevention;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.depenizen.bukkit.objects.griefprevention.GriefPreventionClaimTag;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class GPClaimEnterEvent
extends BukkitScriptEvent
implements Listener {
    public static GPClaimEnterEvent instance;
    public LocationTag from;
    public LocationTag to;
    public GriefPreventionClaimTag new_claim;
    public GriefPreventionClaimTag old_claim;
    public PlayerMoveEvent event;

    public GPClaimEnterEvent() {
        this.registerCouldMatcher("gp player enters|exits <'gpclaim'>");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        String direction = path.eventArgAt(2);
        String claim_test = path.eventArgLowerAt(3);
        if (direction.equals("enters") && this.new_claim != null) {
            if (!claim_test.equals("gpclaim") && !claim_test.equals(CoreUtilities.toLowerCase((String)this.new_claim.simple()))) {
                return false;
            }
            return super.matches(path);
        }
        if (direction.equals("exits") && this.old_claim != null) {
            if (!claim_test.equals("gpclaim") && !claim_test.equals(CoreUtilities.toLowerCase((String)this.old_claim.simple()))) {
                return false;
            }
            return super.matches(path);
        }
        return false;
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.event != null ? new PlayerTag(this.event.getPlayer()) : null, null);
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "to" -> this.to;
            case "from" -> this.from;
            case "old_claim" -> this.old_claim;
            case "new_claim" -> this.new_claim;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onPlayerEntersExitsGPClaim(PlayerMoveEvent event) {
        if (LocationTag.isSameBlock((Location)event.getFrom(), (Location)event.getTo())) {
            return;
        }
        this.from = new LocationTag(event.getFrom());
        this.to = new LocationTag(event.getTo());
        Claim fclaim = GriefPrevention.instance.dataStore.getClaimAt((Location)this.from, false, null);
        Claim tclaim = GriefPrevention.instance.dataStore.getClaimAt((Location)this.to, false, null);
        if (tclaim == fclaim) {
            return;
        }
        this.new_claim = tclaim == null ? null : new GriefPreventionClaimTag(tclaim);
        this.old_claim = fclaim == null ? null : new GriefPreventionClaimTag(fclaim);
        this.event = event;
        this.fire((Event)event);
    }
}

