/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.mcmmo;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.player.UserManager;
import java.util.UUID;
import org.bukkit.OfflinePlayer;

public class PartyTag
implements ObjectTag {
    Party party = null;
    String prefix = "Party";

    @Fetchable(value="party")
    public static PartyTag valueOf(String string, TagContext context) {
        Party party;
        if (string.startsWith("party@")) {
            string = string.substring("party@".length());
        }
        if ((party = PartyManager.getParty((String)string)) == null) {
            return null;
        }
        return new PartyTag(party);
    }

    public static boolean matches(String arg) {
        return PartyManager.getParty((String)(arg = arg.replace("party@", ""))) != null;
    }

    public static PartyTag forPlayer(PlayerTag player) {
        McMMOPlayer pl = UserManager.getOfflinePlayer((OfflinePlayer)player.getOfflinePlayer());
        if (pl == null) {
            return null;
        }
        Party party = pl.getParty();
        if (party == null) {
            return null;
        }
        return new PartyTag(party);
    }

    public PartyTag(Party party) {
        if (party != null) {
            this.party = party;
        } else {
            Debug.echoError((String)"Party referenced is null!");
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "party@" + this.party.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String toString() {
        return this.identify();
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("name")) {
            return new ElementTag(this.party.getName()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("leader")) {
            return new PlayerTag(this.party.getLeader().getUniqueId()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("members")) {
            ListTag players = new ListTag();
            for (UUID uuid : this.party.getMembers().keySet()) {
                players.addObject((ObjectTag)new PlayerTag(uuid));
            }
            return players.getObjectAttribute(attribute.fulfill(1));
        }
        return new ElementTag(this.identify()).getObjectAttribute(attribute);
    }
}

