/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.mcmmo;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.gmail.nossr50.events.experience.McMMOPlayerLevelDownEvent;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class mcMMOPlayerLevelDownScriptEvent
extends BukkitScriptEvent
implements Listener {
    public McMMOPlayerLevelDownEvent event;
    public PlayerTag player;
    public ElementTag skill;
    public int new_level;
    public int levels_lost;
    public ElementTag cause;

    public mcMMOPlayerLevelDownScriptEvent() {
        this.registerCouldMatcher("mcmmo player levels down <'skill'>");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        String eSkill = path.eventArgLowerAt(4);
        if (!eSkill.equals("skill") && !eSkill.equals(CoreUtilities.toLowerCase((String)this.skill.asString()))) {
            return false;
        }
        if (!this.runInCheck(path, (Location)this.player.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        ElementTag element;
        if (determinationObj instanceof ElementTag && (element = (ElementTag)determinationObj).isInt()) {
            this.levels_lost = element.asInt();
            this.event.setLevelsLost(this.levels_lost);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "skill" -> this.skill;
            case "new_level" -> new ElementTag(this.new_level);
            case "old_level" -> new ElementTag(this.new_level + this.levels_lost);
            case "levels_lost" -> new ElementTag(this.levels_lost);
            case "cause" -> this.cause;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onmcMMOPlayerLevelDown(McMMOPlayerLevelDownEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer());
        this.levels_lost = event.getLevelsLost();
        this.new_level = event.getSkillLevel();
        this.cause = new ElementTag(event.getXpGainReason().toString());
        this.skill = new ElementTag(event.getSkill().getName());
        this.event = event;
        this.fire((Event)event);
    }
}

