/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.mythicmobs;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.depenizen.bukkit.objects.mythicmobs.MythicMobsMobTag;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.bukkit.events.MythicMobSpawnEvent;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class MythicMobsSpawnEvent
extends BukkitScriptEvent
implements Listener {
    public static MythicMobsSpawnEvent instance;
    public MythicMobSpawnEvent event;
    public MythicMobsMobTag mythicmob;
    public LocationTag location;

    public MythicMobsSpawnEvent() {
        this.registerCouldMatcher("mythicmob <'mob'> spawns");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        String mob = path.eventArgLowerAt(1);
        if (!mob.equals("mob") && !MythicMobsSpawnEvent.runGenericCheck((String)mob, (String)this.mythicmob.getMobType().getInternalName())) {
            return false;
        }
        if (!this.runInCheck(path, (Location)this.location)) {
            return false;
        }
        return super.matches(path);
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "mob" -> this.mythicmob;
            case "entity" -> new EntityTag(this.event.getEntity());
            case "location" -> this.location;
            case "from_spawner" -> new ElementTag(this.event.isFromMythicSpawner().booleanValue());
            case "spawner_location" -> {
                if (this.event.isFromMythicSpawner().booleanValue()) {
                    AbstractLocation loc = this.event.getMythicSpawner().getLocation();
                    yield new LocationTag(loc.getX(), loc.getY(), loc.getZ(), loc.getWorld().getName());
                }
                yield super.getContext(name);
            }
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onMythicMobSpawns(MythicMobSpawnEvent event) {
        this.mythicmob = new MythicMobsMobTag(event.getMob());
        this.location = new LocationTag(event.getLocation());
        this.event = event;
        EntityTag.rememberEntity((Entity)event.getEntity());
        this.fire((Event)event);
        EntityTag.forgetEntity((Entity)event.getEntity());
    }
}

