/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.mythicmobs;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.depenizen.bukkit.objects.mythicmobs.MythicMobsMobTag;
import io.lumine.mythic.bukkit.BukkitAdapter;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Entity;

public class MythicThreatCommand
extends AbstractCommand {
    public MythicThreatCommand() {
        this.setName("mythicthreat");
        this.setSyntax("mythicthreat [<mythicmob>] [add/subtract/set] [<#.#>] (for:<entity>|...)");
        this.setRequiredArguments(3, 4);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("mythicmob") && arg.matchesArgumentType(MythicMobsMobTag.class)) {
                scriptEntry.addObject("mythicmob", (Object)arg.asType(MythicMobsMobTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("operation") && arg.matchesEnum(Operation.class)) {
                scriptEntry.addObject("operation", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("threat") && arg.matchesFloat()) {
                scriptEntry.addObject("threat", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("targets") && arg.matchesPrefix("for") && arg.matchesArgumentList(EntityTag.class)) {
                scriptEntry.addObject("targets", (Object)((ListTag)arg.asType(ListTag.class)).filter(EntityTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("mythicmob")) {
            throw new InvalidArgumentsException("Must specify a MythicMob!");
        }
        if (!scriptEntry.hasObject("operation")) {
            throw new InvalidArgumentsException("Must specify an Operation!");
        }
        if (!scriptEntry.hasObject("threat")) {
            throw new InvalidArgumentsException("Must specify a threat value!");
        }
        if (!scriptEntry.hasObject("targets")) {
            scriptEntry.defaultObject("targets", new Object[]{Utilities.entryHasPlayer((ScriptEntry)scriptEntry) ? Collections.singletonList(Utilities.getEntryPlayer((ScriptEntry)scriptEntry).getDenizenEntity()) : null});
        }
    }

    public void execute(ScriptEntry scriptEntry) {
        MythicMobsMobTag mythicmob = (MythicMobsMobTag)scriptEntry.getObjectTag("mythicmob");
        ElementTag operation = (ElementTag)scriptEntry.getObjectTag("operation");
        ElementTag threat = scriptEntry.getElement("threat");
        List targets = (List)scriptEntry.getObject("targets");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, (String)this.getName(), (Object[])new Object[]{mythicmob, operation, threat, MythicThreatCommand.db((String)"targets", (Object)targets)});
        }
        if (!mythicmob.getMob().hasThreatTable()) {
            Debug.echoError((String)("MythicMob does not have a threat table: " + String.valueOf(mythicmob)));
            return;
        }
        Operation op = Operation.valueOf(operation.toString().toUpperCase());
        switch (op.ordinal()) {
            case 0: {
                for (EntityTag target : targets) {
                    mythicmob.getMob().getThreatTable().threatGain(BukkitAdapter.adapt((Entity)target.getBukkitEntity()), threat.asDouble());
                }
                break;
            }
            case 1: {
                for (EntityTag target : targets) {
                    mythicmob.getMob().getThreatTable().threatLoss(BukkitAdapter.adapt((Entity)target.getBukkitEntity()), threat.asDouble());
                }
                break;
            }
            case 2: {
                for (EntityTag target : targets) {
                    mythicmob.getMob().getThreatTable().threatSet(BukkitAdapter.adapt((Entity)target.getBukkitEntity()), threat.asDouble());
                }
                break;
            }
        }
    }

    private static enum Operation {
        ADD,
        SUBTRACT,
        SET;

    }
}

