/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.towny;

import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.depenizen.bukkit.objects.towny.TownTag;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import java.util.ArrayList;
import org.bukkit.Location;

public class TownyCuboidProperties
implements Property {
    public static final String[] handledTags = new String[]{"has_town", "list_towns"};
    public static final String[] handledMechs = new String[0];
    CuboidTag cuboid;

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "TownyCuboid";
    }

    public void adjust(Mechanism mechanism) {
    }

    public static boolean describes(ObjectTag object) {
        return object instanceof CuboidTag;
    }

    public static TownyCuboidProperties getFrom(ObjectTag object) {
        if (!TownyCuboidProperties.describes(object)) {
            return null;
        }
        return new TownyCuboidProperties((CuboidTag)object);
    }

    public TownyCuboidProperties(CuboidTag cuboid) {
        this.cuboid = cuboid;
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute.startsWith("has_town")) {
            for (Location location : this.cuboid.getBlockLocationsUnfiltered(true)) {
                if (TownyAPI.getInstance().getTownName(location) == null) continue;
                return new ElementTag(true).getObjectAttribute(attribute.fulfill(1));
            }
            return new ElementTag(false).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_towns")) {
            ListTag list = new ListTag();
            ArrayList<String> towns = new ArrayList<String>();
            try {
                for (Location location : this.cuboid.getBlockLocationsUnfiltered(true)) {
                    String townName = TownyAPI.getInstance().getTownName(location);
                    if (townName == null || towns.contains(townName)) continue;
                    list.addObject((ObjectTag)new TownTag(TownyAPI.getInstance().getTownBlock(location).getTown()));
                    towns.add(townName);
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            return list.getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }
}

