/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.towny;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.depenizen.bukkit.objects.towny.TownTag;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.TownBlock;
import java.util.UUID;
import org.bukkit.Location;

public class TownyLocationProperties {
    public static void register() {
        LocationTag.tagProcessor.registerTag(ElementTag.class, "towny_allows_pvp", (attribute, location) -> new ElementTag(TownyAPI.getInstance().isPVP((Location)location)), new String[0]);
        LocationTag.tagProcessor.registerTag(PlayerTag.class, "towny_resident", (attribute, location) -> {
            try {
                return TownyLocationProperties.getResidentAtLocation(location);
            }
            catch (NotRegisteredException ex) {
                if (!attribute.hasAlternative()) {
                    attribute.echoError("Towny tag NotRegisteredException: " + ex.getMessage());
                }
                return null;
            }
        }, new String[0]);
        LocationTag.tagProcessor.registerTag(PlayerTag.class, "towny", (attribute, location) -> {
            block3: {
                try {
                    if (attribute.startsWith("resident", 2)) {
                        attribute.fulfill(1);
                        return TownyLocationProperties.getResidentAtLocation(location);
                    }
                }
                catch (NotRegisteredException ex) {
                    if (attribute.hasAlternative()) break block3;
                    attribute.echoError("Towny tag NotRegisteredException: " + ex.getMessage());
                }
            }
            return null;
        }, new String[0]);
        LocationTag.tagProcessor.registerTag(ElementTag.class, "towny_type", (attribute, location) -> {
            TownBlock block = TownyAPI.getInstance().getTownBlock((Location)location);
            if (block != null) {
                return new ElementTag(block.getType().getName());
            }
            return null;
        }, new String[0]);
        LocationTag.tagProcessor.registerTag(ElementTag.class, "has_town", (attribute, location) -> new ElementTag(TownyAPI.getInstance().getTown((Location)location) != null), new String[0]);
        LocationTag.tagProcessor.registerTag(TownTag.class, "town", (attribute, location) -> {
            String town = TownyAPI.getInstance().getTownName((Location)location);
            if (town == null) {
                return null;
            }
            return new TownTag(TownyUniverse.getInstance().getTown(town));
        }, new String[0]);
        LocationTag.tagProcessor.registerTag(ElementTag.class, "is_nation_zone", (attribute, location) -> new ElementTag(TownyAPI.getInstance().isNationZone((Location)location)), new String[0]);
        LocationTag.tagProcessor.registerTag(ElementTag.class, "is_wilderness", (attribute, location) -> new ElementTag(TownyAPI.getInstance().isWilderness((Location)location)), new String[0]);
    }

    public static PlayerTag getResidentAtLocation(LocationTag location) throws NotRegisteredException {
        TownBlock block = TownyAPI.getInstance().getTownBlock((Location)location);
        if (block == null) {
            return null;
        }
        if (!block.hasResident()) {
            return null;
        }
        UUID player = block.getResident().getUUID();
        if (player == null) {
            return null;
        }
        return new PlayerTag(player);
    }
}

