/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.utilities.mythicmobs.conditions;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.tags.ParseableTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.conditions.ICasterCondition;
import io.lumine.mythic.api.skills.conditions.IEntityComparisonCondition;
import io.lumine.mythic.api.skills.conditions.IEntityCondition;
import io.lumine.mythic.api.skills.conditions.ILocationCondition;
import io.lumine.mythic.api.skills.conditions.ISkillMetaCondition;
import java.util.HashMap;
import org.bukkit.World;

public class DenizenCondition
implements IEntityCondition,
ILocationCondition,
ICasterCondition,
ISkillMetaCondition,
IEntityComparisonCondition {
    public ParseableTag tag;
    public ContextSource.SimpleMap source;

    public DenizenCondition(String line, MythicLineConfig mlc) {
        this.tag = TagManager.parseTextToTag((String)mlc.getString("tag"), (TagContext)CoreUtilities.noDebugContext);
        this.source = new ContextSource.SimpleMap();
        this.source.contexts = new HashMap();
    }

    public void reset() {
        this.source.contexts.clear();
    }

    public boolean check(AbstractEntity entity) {
        this.reset();
        this.source.contexts.put("target", new EntityTag(entity.getBukkitEntity()).getDenizenObject());
        return this.runCheck();
    }

    public boolean check(AbstractLocation location) {
        this.reset();
        this.source.contexts.put("location", new LocationTag((World)location.getWorld(), location.getX(), location.getY(), location.getZ()));
        return this.runCheck();
    }

    public void addContext(SkillCaster caster) {
        this.source.contexts.put("entity", new EntityTag(caster.getEntity().getBukkitEntity()).getDenizenObject());
        AbstractEntity target = caster.getEntity().getTarget();
        if (target != null) {
            this.source.contexts.put("target", new EntityTag(target.getBukkitEntity()).getDenizenObject());
        }
    }

    public boolean check(SkillCaster caster) {
        this.reset();
        this.addContext(caster);
        return this.runCheck();
    }

    public boolean check(SkillMetadata skillMetadata) {
        this.reset();
        if (skillMetadata.getTrigger() != null) {
            this.source.contexts.put("trigger", new EntityTag(skillMetadata.getTrigger().getBukkitEntity()).getDenizenObject());
        }
        this.addContext(skillMetadata.getCaster());
        return this.runCheck();
    }

    public boolean check(AbstractEntity entity1, AbstractEntity entity2) {
        this.source.contexts.put("entity", new EntityTag(entity1.getBukkitEntity()).getDenizenObject());
        this.source.contexts.put("target", new EntityTag(entity2.getBukkitEntity()).getDenizenObject());
        return this.runCheck();
    }

    public boolean runCheck() {
        TagContext tagContext = CoreUtilities.noDebugContext.clone();
        tagContext.contextSource = this.source;
        ObjectTag object = this.tag.parse(tagContext);
        return object.asElement().asBoolean();
    }
}

