/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.utilities;

import java.lang.invoke.MethodHandle;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.IronGolem;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.mcmonkey.sentinel.utilities.SentinelVersionCompat;

public class SentinelNMSHelper {
    public static MethodHandle CRAFTENTITY_GETHANDLE;
    public static MethodHandle NMSENTITY_WORLDGETTER;
    public static MethodHandle NMSWORLD_BROADCASTENTITYEFFECT;
    public static MethodHandle NMSENTITY_GETDATAWATCHER;
    public static MethodHandle DATWATCHER_SET;
    private static boolean nmsWorks;
    public static MethodHandle INVENTORYCLOSEEVENT_GETVIEW;
    public static MethodHandle INVENTORYVIEW_GETTITLE;

    public static Class<?> getOptionalFieldType(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName).getType();
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
    }

    public static void init() {
        try {
            Class<?> nmsDataWatcherObject;
            Class<?> nmsDataWatcher;
            Class<?> nmsWorld;
            Class<?> nmsEntity;
            if (SentinelVersionCompat.v1_10) {
                INVENTORYCLOSEEVENT_GETVIEW = NMS.getMethodHandle(InventoryEvent.class, (String)"getView", (boolean)true, (Class[])new Class[0]);
                INVENTORYVIEW_GETTITLE = NMS.getMethodHandle((Class)INVENTORYCLOSEEVENT_GETVIEW.type().returnType(), (String)"getTitle", (boolean)true, (Class[])new Class[0]);
            }
            if (!SentinelVersionCompat.v1_12) {
                nmsWorks = false;
                return;
            }
            String bukkitPackageName = Bukkit.getServer().getClass().getPackage().getName();
            Class<?> craftEntity = Class.forName(bukkitPackageName + ".entity.CraftEntity");
            CRAFTENTITY_GETHANDLE = NMS.getMethodHandle(craftEntity, (String)"getHandle", (boolean)true, (Class[])new Class[0]);
            String broadcastEffectMethod = "broadcastEntityEffect";
            String dataWatcherSet = "set";
            if (SentinelVersionCompat.v1_17) {
                nmsEntity = Class.forName("net.minecraft.world.entity.Entity");
                nmsWorld = Class.forName("net.minecraft.world.level.World");
                nmsDataWatcher = Class.forName("net.minecraft.network.syncher.DataWatcher");
                nmsDataWatcherObject = Class.forName("net.minecraft.network.syncher.DataWatcherObject");
                if (SentinelVersionCompat.v1_21 && !SentinelVersionCompat.vFuture) {
                    broadcastEffectMethod = "a";
                    dataWatcherSet = "a";
                } else if (SentinelVersionCompat.v1_20 && !SentinelVersionCompat.v1_21) {
                    broadcastEffectMethod = "a";
                    dataWatcherSet = "a";
                } else if (SentinelVersionCompat.v1_19 && !SentinelVersionCompat.v1_20) {
                    broadcastEffectMethod = "a";
                    dataWatcherSet = "b";
                } else if (SentinelVersionCompat.v1_18 && !SentinelVersionCompat.v1_19) {
                    broadcastEffectMethod = "a";
                    dataWatcherSet = "b";
                }
            } else {
                String packageVersion = bukkitPackageName.substring(bukkitPackageName.lastIndexOf(46) + 1);
                String nmsPackageName = "net.minecraft.server." + packageVersion;
                nmsEntity = Class.forName(nmsPackageName + ".Entity");
                nmsWorld = Class.forName(nmsPackageName + ".World");
                nmsDataWatcher = Class.forName(nmsPackageName + ".DataWatcher");
                nmsDataWatcherObject = Class.forName(nmsPackageName + ".DataWatcherObject");
            }
            NMSENTITY_WORLDGETTER = NMS.getFirstGetter(nmsEntity, nmsWorld);
            NMSENTITY_GETDATAWATCHER = NMS.getFirstGetter(nmsEntity, nmsDataWatcher);
            NMSWORLD_BROADCASTENTITYEFFECT = NMS.getMethodHandle(nmsWorld, (String)broadcastEffectMethod, (boolean)true, (Class[])new Class[]{nmsEntity, Byte.TYPE});
            DATWATCHER_SET = NMS.getMethodHandle(nmsDataWatcher, (String)dataWatcherSet, (boolean)true, (Class[])new Class[]{nmsDataWatcherObject, Object.class});
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            nmsWorks = false;
        }
    }

    public static void animateIronGolemSwing(IronGolem entity) {
        if (!nmsWorks) {
            return;
        }
        try {
            Object nmsHandle = CRAFTENTITY_GETHANDLE.invoke(entity);
            Object world = NMSENTITY_WORLDGETTER.invoke(nmsHandle);
            NMSWORLD_BROADCASTENTITYEFFECT.invoke(world, nmsHandle, (byte)4);
        }
        catch (Throwable ex) {
            nmsWorks = false;
            ex.printStackTrace();
        }
    }

    public static void setEndermanAngry(Enderman entity, boolean angry) {
        NMS.setEndermanAngry((Enderman)entity, (boolean)angry);
    }

    public static String getInventoryTitle(InventoryEvent event) {
        try {
            if (SentinelVersionCompat.v1_10) {
                Object view = INVENTORYCLOSEEVENT_GETVIEW.invoke(event);
                return INVENTORYVIEW_GETTITLE.invoke(view);
            }
            Inventory inventory = event.getInventory();
            return (String)inventory.getClass().getMethod("getTitle", new Class[0]).invoke((Object)inventory, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static {
        nmsWorks = true;
    }
}

